import { EmitableEvent, EventEmitter } from '@/core/common/eventEmitter';
import { KeyCode } from '@/plugin/keyCodes';
export interface KeyboardEmits {
    key: KeyCode;
    assist: number;
}
interface KeyboardItem {
    key: KeyCode;
    text?: string;
    x: number;
    y: number;
    width: number;
    height: number;
}
interface VirtualKeyEmit {
    preventDefault(): void;
    preventAssist(): void;
}
type VirtualKeyEmitFn = (item: KeyboardItem, assist: number, index: number, ev: VirtualKeyEmit) => void;
interface VirtualKeyboardEvent extends EmitableEvent {
    add: (item: KeyboardItem) => void;
    remove: (item: KeyboardItem) => void;
    extend: (extended: Keyboard) => void;
    emit: VirtualKeyEmitFn;
    scopeCreate: (scope: symbol) => void;
    scopeDispose: (scope: symbol) => void;
}
/**
 * 虚拟按键，同一个虚拟按键实例应当只能同时操作一个，但可以显示多个
 */
export declare class Keyboard extends EventEmitter<VirtualKeyboardEvent> {
    static list: Keyboard[];
    id: string;
    keys: KeyboardItem[];
    assist: number;
    fontSize: number;
    scope: symbol;
    private scopeStack;
    private onEmitKey;
    private scopeAssist;
    constructor(id: string);
    /**
     * 给虚拟键盘添加一个按键
     * @param item 按键信息
     */
    add(item: KeyboardItem): this;
    /**
     * 移除一个按键
     * @param item 按键信息
     */
    remove(item: KeyboardItem): this;
    /**
     * 创造一个在某些辅助按键已经按下的情况下的作用域，这些被按下的辅助按键还可以被玩家手动取消
     * @param assist 辅助按键
     */
    withAssist(assist: number): symbol;
    /**
     * 创造一个虚拟按键作用域，所有监听的事件与其他作用域不冲突
     * @returns 作用域的唯一标识符
     */
    createScope(): symbol;
    /**
     * 释放一个作用域，同时删除其中的所有监听器
     */
    disposeScope(): void;
    /**
     * 继承一个按键的按键信息
     * @param keyboard 要被继承的按键
     * @param offsetX 被继承的按键的横坐标偏移量
     * @param offsetY 被继承的按键的纵坐标偏移量
     */
    extend(keyboard: Keyboard, offsetX?: number, offsetY?: number): this;
    /**
     * 触发按键
     * @param key 要触发的按键
     */
    emitKey(key: KeyboardItem, index: number): void;
    static get(id: string): Keyboard | undefined;
}
export declare function generateKeyboardEvent(key: KeyCode, assist: number): KeyboardEvent;
export {};
